<!DOCTYPE HTML>
<HTML>
	<HEAD>
		<title>RBL Check</title>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<meta name="description" content="Tool to check DNSBL/RBL listing of the Server's IP" />
		<meta name="author" content="Alberto Radice, Alex Guerrazzi" />
	</HEAD>
	
	<BODY>

	<?
		
		$logbuffer = file_get_contents('log.txt');	//carica il contenuto attuale del file di log
	
		$log = 'log.txt';	//istanzia il file log.txt
	
		//timestamp per log
		$log_date = date("j/n/Y");
		$log_time = date("G:i:s");
	
		$logbuffer .= "\r\n\r\n### Script eseguito il $log_date alle $log_time ###\r\n";
		
		if ($com = new COM("IceWarpServer.APIObject")){
	  		//echo "IceWarpServer.APIObject invocata<br /><br/>";	//conferma invocazione oggetto
		}
		else{
	  		echo "L'API non ha potuto essere invocata";
			$logbuffer .= "L'API non ha potuto essere invocata\r\n";
	  		return;
		}
		
		$handle = fopen("http://www.icewarp.it/whatismyip", "r");	//ottieni l'IP pubblico dal quale la pagina è richiamata
		$ip = stream_get_contents($handle);
		fclose($handle);
		
		$notify=0;	//flag per notifica e-mail
			
		echo "<b>Il tuo IP &egrave; $ip</b><br/><br/>"; 
		
		$blacklists = array(array("b.barracudacentral.org","http://barracudacentral.org/rbl"),
							array("bl.deadbeef.com","http://spam.deadbeef.com/bl/"),
							array("bl.emailbasura.org","http://www.emailbasura.org/"),
							array("bl.spamcannibal.org","http://www.spamcannibal.org/"),
							array("bl.spamcop.net","http://www.spamcop.net/bl.shtml"),
							//array("blackholes.five-ten-sg.com","http://www.five-ten-sg.com/blackhole.php"),	//blacklist retired
							array("blacklist.woody.ch","http://blacklist.woody.ch/rblcheck.php3"),
							array("bogons.cymru.com","http://www.team-cymru.org/Services/Bogons/mailblock.html"),
							array("cbl.abuseat.org","http://cbl.abuseat.org/"),
							array("cdl.anti-spam.org.cn","http://www.anti-spam.org.cn/CID/17"),
							array("combined.abuse.ch","http://dnsbl.abuse.ch/"),
							array("combined.rbl.msrbl.net","./"),
							array("db.wpbl.info","http://www.wpbl.info/"),
							array("dnsbl-1.uceprotect.net","http://www.uceprotect.net/"),
							array("dnsbl-2.uceprotect.net","http://www.uceprotect.net/"),
							array("dnsbl-3.uceprotect.net","http://www.uceprotect.net/"),
							array("dnsbl.ahbl.org","http://www.ahbl.org/"),
							array("dnsbl.cyberlogic.net","http://www.cyberlogic.net/"),
							array("dnsbl.inps.de","http://www.inps.de/"),
							//array("dnsbl.njabl.org","http://www.njabl.org/"),	//closed
							array("dnsbl.sorbs.net","http://www.sorbs.net/"),
							array("drone.abuse.ch","http://dnsbl.abuse.ch/"),
							array("duinv.aupads.org","http://www.aupads.org/using.html"),
							array("dul.dnsbl.sorbs.net","http://www.sorbs.net/"),
							array("dul.ru","http://www.dul.ru"),
							array("dyna.spamrats.com","http://www.spamrats.com/"),
							array("dynip.rothen.com","http://antispam.rothen.com/"),
							array("http.dnsbl.sorbs.net","http://www.sorbs.net/"),
							array("images.rbl.msrbl.net","http://msrbl.blogspot.it/"),
							array("ips.backscatterer.org","http://www.backscatterer.org/"),
							array("ix.dnsbl.manitu.net","http://www.dnsbl.manitu.net/"),
							array("korea.services.net","././.html"),
							array("misc.dnsbl.sorbs.net","http://www.sorbs.net/"),
							array("noptr.spamrats.com","http://www.spamrats.com/rats-noptr.php"),
							array("ohps.dnsbl.net.au","./"),
							array("omrs.dnsbl.net.au","./"),
							array("orvedb.aupads.org","http://www.aupads.org/ordb.html"),
							array("osps.dnsbl.net.au","./"),
							array("osrs.dnsbl.net.au","./"),
							array("owfs.dnsbl.net.au","./"),
							array("owps.dnsbl.net.au","./"),
							array("pbl.spamhaus.org","http://www.spamhaus.org/pbl/"),
							array("phishing.rbl.msrbl.net","./"),
							array("probes.dnsbl.net.au","./"),
							array("proxy.bl.gweep.ca","./"),
							array("proxy.block.transip.nl","./"),
							array("psbl.surriel.com","http://psbl.surriel.com/"),
							array("rbl.interserver.net","http://rbl.interserver.net/"),
							array("rdts.dnsbl.net.au","./"),
							array("relays.bl.gweep.ca","./"),
							array("relays.bl.kundenserver.de","http://relaytest.kundenserver.de/"),
							array("relays.nether.net","http://puck.nether.net/or/"),
							array("residential.block.transip.nl","./"),
							array("ricn.dnsbl.net.au","./"),
							array("rmst.dnsbl.net.au","http://dnsbl.net.au/rmst"),
							array("sbl.spamhaus.org","http://www.spamhaus.org/sbl/"),
							array("short.rbl.jp","http://www.rbl.jp/"),
							array("smtp.dnsbl.sorbs.net","http://www.sorbs.net/"),
							array("socks.dnsbl.sorbs.net","http://www.sorbs.net/"),
							array("spam.abuse.ch","http://dnsbl.abuse.ch/"),
							array("spam.dnsbl.sorbs.net","http://www.sorbs.net/"),
							array("spam.rbl.msrbl.net","./"),
							array("spam.spamrats.com","http://www.spamrats.com/"),
							array("spamlist.or.kr","https://www.kisarbl.or.kr/english/"),
							array("spamrbl.imp.ch","./"),
							array("t3direct.dnsbl.net.au","./"),
							array("tor.ahbl.org","./"),
							array("tor.dnsbl.sectoor.de","./"),
							array("torserver.tor.dnsbl.sectoor.de","./"),
							array("ubl.lashback.com","http://www.lashback.com/blacklist/"),
							array("ubl.unsubscore.com","http://www.lashback.com/support/UnsubscribeBlacklistSupport.aspx"),
							array("virbl.bit.nl","http://virbl.bit.nl/lookup/"),
							array("virus.rbl.jp","http://www.rbl.jp/virus-e.html"),
							array("virus.rbl.msrbl.net","./"),
							array("web.dnsbl.sorbs.net","http://www.sorbs.net/"),
							array("wormrbl.imp.ch","http://antispam.imp.ch/03-wormlist.html?lng=1"),
							array("xbl.spamhaus.org","http://www.spamhaus.org/xbl"),
							array("zen.spamhaus.org","http://www.spamhaus.org/zen/"),
							array("zombie.dnsbl.sorbs.net","http://www.sorbs.net/"));
	
		function dnsbl_check($ip, $dnsbl) {	//funzione che restituisce 1 in caso di match, 0 in caso di NON match, -1 nel caso in cui il valore passato non sia un IP
			if (preg_match("/^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}?(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/",$ip) == 1) {
				$octets = preg_split("/\./",$ip);
				return checkdnsrr($octets[3].".".$octets[2].".".$octets[1].".".$octets[0].".".$dnsbl,"A");	//restituisce 0 se nessun record A viene trovato, 1 se il record A viene trovato
			} else {
				return -1;		
			}
		}
		
		foreach ($blacklists as $blacklist) {
			if (dnsbl_check($ip,$blacklist[0]) == 1) {
				echo "<a href=$blacklist[1] target=\"_blank\" style=\"text-decoration: none\"><font color=\"#FF0000\">".$blacklist[0]."</font></a><br>";
				$listed .="<a href=$blacklist[1]>".$blacklist[0]."</a><br/>";
				$listed_log .= "$blacklist[0]\r\n";
				$notify=1;	//notifica
			} else {
				echo "<a href=$blacklist[1] target=\"_blank\" style=\"text-decoration: none\"><font color=\"#00AA00\">".$blacklist[0]."</font></a><br>";
			}
		}
		
		if ($notify){
		
			$report_address = $com->GetProperty(c_system_tools_monitor_reportaddress);	// [Monitor di sistema > Indirizzo e-mail allarmi]
					
					
			if(strlen($report_address) > 0){	//se l'indirizzo e-mail degli allarmi non è vuoto
				$rcpt = $report_address;		//impostalo come destinatario del messaggio
			}else{
				$prim_dom = $com->OpenDomain($com->GetDomain(0));	//altrimenti identifica il dominio primario
		  		$domName = $prim_dom->Name;							
				$adminemail = $prim_dom->GetProperty(d_adminemail);	//estraine l'indirizzo dell'amministratore
				$rcpt = $adminemail;								//e impostalo come destinatario del messaggio
			}
	
	
			// *** PARAMETRI PER MAIL DI NOTIFICA ***
		
			$com1 = new COM("IceWarpCOM.Mailer");
	
		   	$com1->RemoteHost = "localhost";	//Server di invio
		   	$com1->Helo = "localhost";			//Comando HELO
		
		   	// Header mittente
		   	$com1->FromName = "RBL Check";				//Nome
		   	$com1->FromAddress = "noreply-rblcheck@demo.com";	//Indirizzo
		   	// Parametri di INVIO
		   	$com1->MailFrom = "rblcheck@demo.com";		//Indirizzo mittente
		   	$com1->AddRecipient($rcpt, "Responsabile");	//Indirizzo e Nome destinatario
		
		   	$com1->Subject = "Avviso RBL";	//Oggetto della mail
		   	$com1->IsHTML = TRUE;			//Composizione HTML
		   	$com1->BodyText = "***ATTENZIONE***<br/><br/>L'IP $ip risulta attualmente inserito nelle seguenti liste<br/><br/> $listed";
		
			$logbuffer .= "\r\nIP $ip inserito in \r\n\r\n$listed_log\r\n";
		
		   	if (!$com1->SendMail()) echo $com1->Response;
		   
		   	echo "<br/>La mail di notifica &egrave; stata inviata a <b>$rcpt</b><br/>";
			$logbuffer .= "La mail di notifica è stata inviata a $rcpt\r\n\r\n";
			
		   	$com1 = null;
			
			// **************************************
			
		}
	
		$logbuffer .= "##################################################";
	
		file_put_contents($log, $logbuffer); //Scrittura sul file di log
		
	?>
	
	</BODY>
	
</HTML>