<?
// PHP timelimit 5 h
ini_set('max_execution_time',18000);


// *** LIVELLO DI LOG ***
$log_level = 1;	//0 Disabilitato, 1 Sintetico, 2 Completo 

// *** PARAMETRI DI ESECUZIONE ***

$from = date("Y/n/j");	//Data di inizio
$to = date("Y/n/j");	//Data di fine
$limit = 2;	//limite messaggi oltre il quale l'account viene disabilitato

// *******************************

class myCOM {
   private $base;
   private $name;

   function __construct($obj, $base='') {
      if ( $base == '' ) {
         $this->name = strtoupper($obj);
         $this->base = icewarp_apiobjectcall( 0, '', $obj );
      }
      else {
         $this->base=$base;
      }
   }

   function __destruct() {
      /*icewarp_apiobjectcall( $this->base );*/
   }

   private function check4object ( $value, $method ) {
      
      /* Methods that return a new object */
      if ( $method == 'OpenAccount' ) {
         return new myCOM( '', $value );
      } elseif ( $method == 'GetProperty' ) {
         return $value;
      } else  {
         /* Old linux compatibility */
         if ( ctype_xdigit( $value ) && ( strlen( $value ) == 8 ) ) {
            $ret = new myCOM( '', $value );
         } else {
            $ret = $value;
         }
      }

      return $ret;
   }

   function __call( $method, $args ) {
      $ret = icewarp_apiobjectcall ( $this->base, $method, $args[0], $args[1], $args[2], $args[3], $args[4] );
      # Converte in oggetti solo per alcuni metodi
      if ( $method!='GetProperty' )
      $ret = $this->check4object( $ret, $method );
      return $ret;
   }

   function __set ( $name, $value ) {
      if ( $this->name == "ICEWARPSERVER.MAILER" )
      $name = "Set_$name";
      $ret=icewarp_apiobjectcall ( $this->base, $name, strval($value) );
      return $ret;
   }

   function __get ( $name ) {
      if ( $this->name == "ICEWARPSERVER.MAILER" )
      $name = "Get_$name";
      $ret=icewarp_apiobjectcall ( $this->base, $name );
      return $ret;
   }
}


// ---------------------


// --- Controllo ---

if ($log_level > 0){
   $logbuffer = "";
   $log = 'log.txt';	//istanzia il file log.txt
}


//timestamp per log
$log_date = date("j/n/Y");
$log_time = date("G:i:s");

if ($log_level > 0){
   file_put_contents($log, "\r\n\r\n### Esecuzione avviata il $log_date alle $log_time # \r\n", FILE_APPEND);
}

if ($com = new myCOM("IceWarpServer.APIObject")) {
   //echo "IceWarpServer.APIObject invocata<br /><br/>";	//conferma invocazione oggetto
}
else
{
   //echo "L'API non ha potuto essere invocata";
   if ($log_level > 0){
      file_put_contents($log, "L'API non ha potuto essere invocata", FILE_APPEND);
   }
   return;
}


$disabled_accounts = array();

if ($log_level > 0){
   $logbuffer = "";
   $logbuffer .= "Data di inizio: $from \r\n";
   $logbuffer .= "Data di fine: $to \r\n";
   $logbuffer .= "Limite messaggi: $limit \r\n";
   file_put_contents($log, $logbuffer, FILE_APPEND);
}

$domCount = $com->GetDomainCount();
for ($i = 0; $i < $domCount; $i++)
{
   $domain = $com->OpenDomain($com->GetDomain($i));
   if ( !is_object($domain) ) {
      continue;
   }  
   $domName = $domain->Name;
   if ($log_level > 1){
      file_put_contents($log, "\r\n \r\n=====================\r\nDominio: $domName \r\n \r\n", FILE_APPEND);
   }

   $accNum = $domain->GetAccountCount();
   for ($j = 0; $j < $accNum; $j++)
   {
      $acc = $domain->OpenAccount($domain->GetAccount($j));
      if (($acc->GetProperty("U_Type"))==0)	//Solo se l'account è di tipo UTENTE
      {
         $accAlias = $acc->GetProperty("U_Alias");
         $accPath = $acc->GetProperty("U_FullMailboxPath");
         
         $mailPattern = "$accAlias@$domName";	//Stringa utilizzata come filtro delle statistiche account
         
         if ($log_level > 1){
            file_put_contents($log, "\r\n---\r\nAlias: $accAlias \r\nPercorso casella: $accPath \r\n", FILE_APPEND);
         }
         
         $accStats = $com->GetUserStatistics($from,$to,$mailPattern);
         
         $array_stat = str_getcsv($accStats,',','"','/');	//creazione di un array da una stringa CSV
         //print_r($array_stat);
         $sentOut = $array_stat[21];	//il 21esimo elemento dell'array sono i MESSAGGI INVIATI ALL'ESTERNO
         
         if ($log_level > 1){
            if ($sentOut==1){	
               file_put_contents($log, "L'utente ha inviato $sentOut messaggio all'esterno nel periodo definito", FILE_APPEND);
            } else {
               file_put_contents($log, "L'utente ha inviato $sentOut messaggi all'esterno nel periodo definito", FILE_APPEND);
            }
         }  
         
         if ($sentOut > $limit) 
         {
            $status = $acc->GetProperty("u_smtp");
            if ($status==1)	//se l'invio è attualmente attivo
            {
               $acc->SetProperty("u_smtp", 0);
               $acc->Save();
               if ($log_level > 1){
                  file_put_contents($log, "\r\n***L'account viene ora DISABILITATO***", FILE_APPEND);
               } else if ($log_level > 0){
                  file_put_contents($log, "\r\n***L'account $accAlias@$domName ha inviato $sentOut messaggi e viene ora DISABILITATO***\r\n", FILE_APPEND);
               }	
            } else {
               if ($log_level > 1){
                  file_put_contents($log, "\r\nL'account era già stato DISABILITATO", FILE_APPEND);
               } else if ($log_level > 0){
                  file_put_contents($log, "\r\n***L'account $accAlias@$domName ha inviato $sentOut messaggi ed era già stato DISABILITATO***\r\n", FILE_APPEND);
               }	
            }
            
            $aliases = $acc->GetProperty("u_aliaslist");
            
            $address = explode(";", $aliases);
            
            $disabled_accounts[] = $address[0]; 
            
         }
         
      }
      
   }
}


foreach ($disabled_accounts as $k1 => $d_account){
   $disabled_list = $disabled_list."	".$d_account."<br />";
}

// ----------------- 


// *** PARAMETRI PER MAIL DI NOTIFICA ***

$msg_body = "I seguenti account sono stati bloccati dallo script di prevenzione di invii massivi <br /><br />".$disabled_list;	//Corpo del messaggio

$rcpt_name = "Server Administrator";	//Nome destinatario
$rcpt_address = "admin@demo.com";		//Indirizzo destinatario

if (count($disabled_accounts)>0){
   
   $com1 = new COM("IceWarpServer.Mailer");

   $com1->RemoteHost = "localhost";	//Server di invio
   $com1->Helo = "localhost";		//Comando HELO

   // Header mittente
   $com1->FromName = "FloodBlocker";		//Nome
   $com1->FromAddress = "floodblocker@demo.com";	//Indirizzo
   // Parametri di INVIO
   $com1->MailFrom = "floodblocker@demo.com";		//Indirizzo mittente
   $com1->AddRecipient($rcpt_address, $rcpt_name);

   $com1->Subject = "Account bloccati";	//Oggetto della mail
   $com1->IsHTML = TRUE;	
   $com1->BodyText = $msg_body;

   if (!$com1->SendMail()) echo $com1->Response;
   
   if ($log_level>0){
      file_put_contents($log, "Mail di notifica inviata a: $rcpt_name <$rcpt_address>\r\n\r\n", FILE_APPEND);
   }	
   $com1 = null;
   
}

// **************************************

if ($log_level>0){
   $log_time = date("G:i:s");
   $logbuffer = "";
   $logbuffer .= "\r\n\r\n######## Esecuzione conclusa alle $log_time ########\r\n";
   $logbuffer .= "##################################################";
   file_put_contents($log, $logbuffer, FILE_APPEND); //Scrittura sul file di log
}
?>