<?PHP
# File di testo con i dati per i calcoli della Gaussiana
# Formato:
# <ID>,<DATA AGGIORNAMENTO>,<termine 1>;<termine 2>;<termine n>

define (DATI, "c:\\dati.txt" );

function ReadOnlyData ( $id, &$last ) {
   $linee=file(DATI);
   foreach( $linee as $linea ) {
      list($name,$quando,$dati)=explode(',',trim($linea), 3 );
      if ( $name == $id ) {
	     $last = $quando;
         return explode(';',$dati);
		}
   }
   
   return Array();
}

// Carica i valori della serie e ne calcola media e varianza.
// L'ultimo valore inserito viene considerato come il punto da controllare e non viene utilizzato nel calcolo di media e varianza.
// Array dei valori ritornati:
// 'C' - Numero di elementi della serie consideranti nel calcolo statistico
// 'M' - Media
// 'S' - Varianza
// 'S2' - Scarto quadratico medio
// 'L' - data dell'ultimo inserimento AAAAMMGG
// 'V' - Ultimo valore della serie, quello pi recente da verificare
function ReadData( $id ) {
   $valori=ReadOnlyData($id, $last);
   if ( count($valori)>2 ) {
      $value = array_pop( $valori );
	  
      $media=0;
      foreach ( $valori as $valore ) {
         $media += $valore;
      }
      $media /= count($valori);

	  $sigma2=0;
      foreach ( $valori as $valore ) {
         $sigma2 += pow(($valore-$media),2);
      }
      $sigma2 /= count($valori);

      return Array( 'C'=>count($valori), 'M'=>$media, 'S'=>sqrt($sigma2), 'S2'=>$sigma2, 'L'=>$last, 'V'=>$value );
   } else {
      return Array();
   }
}

function SaveData ( $id, $last, $valori ) {
   $found=FALSE;

   $linee=file(DATI);
   $fp = fopen( DATI,'w+' );
   if ( $fp ) {
      foreach( $linee as $linea ) {
         list($name,$quando,$dati)=explode(',',$linea, 3 );
         if ( $name == $id ) {
            $found = TRUE;
            $linea="$id,$last,".implode(';',$valori)."\n";
         }
         fwrite( $fp, $linea );
      }

	  // Se non ha trovato la linea bisogna aggiungerla
      if ( $found == FALSE )
         fwrite( $fp, "$id,$last,".implode(';',$valori)."\n");
      fclose( $fp );
   }
}

function AddData( $id, $count, $quando, $val ) {
   $valori = ReadOnlyData( $id, $last );
   if ( $quando > $last ) {
      $valori[] = $val;
      while ( count($valori) > $count ) {
         array_shift( $valori );
      }

   SaveData( $id, $quando, $valori );
   }
}

// Controlla che l'ultimo dato della serie sia coerente con media e varianza dei precedenti
function CheckValue ( $id, &$msg ) {
   //echo "ID: $id\n";
   $valori=ReadData( $id );
   if ( count($valori) > 0 ) {
      //print_r($valori);
      $scostamento=abs($valori['V']-$valori['M'])-2*$valori['S'];
      if ( $scostamento > 0 ) {
         $msg .= "$id scostamento oltre il limite V:".$valori['V']." M:".$valori['M']." S:".$valori['S']."\n";
         return TRUE;
      }
      else
         return FALSE;
   }

   return FALSE;
}

?>