<?
set_time_limit(0);
require("handle_data.php");

define("MAX_RELAY", 100 );
define("DAYS_OF_DATA", 15 );

if (!( $com = new COM("IceWarpServer.APIObject" ) )) {
   echo "Errore invocando l'oggetto COM IceWarpServer.APIObject";
   exit ( 1 );
}

if ( $com->GetProperty("C_Accounts_Global_Accounts_UserStat")<>1 ) {
   echo "E' richiesta l'attivazione delle statistiche per utente";
   exit ( 1 );
}

define( "DATA_FILE", escapeshellarg($com->GetProperty("C_InstallPath")."/LogAnalyzer/mystats.csv") );

/*
    Formato del risultato di GetUserStatistics
     Array
(
    [0] => [Domain]
    [1] => [Alias]
    [2] => [Received Messages]
    [3] => [Received Amount]
    [4] => [Sent Messages]
    [5] => [Sent Amount]
    [6] => [Sent Out Messages]
    [7] => [Sent Out Amount]
    [8] => [Last Sent]
    [9] => [Last Received]
    [10] => [Last Login]
    [11] => [Messages Count]
    [12] => [Messages Amount]
    [13] => [Created]
    [14] => [LastIP]
    [15] => [Mailbox Quota]
)
*/

function GetMailStatistics ( $date, &$msg )
{
   global $com,$domains;
   $act_domain="";
   
   $list = explode("\n", str_replace(array("\n", "\r\n"), "\n", $com->GetUserStatistics( $date, $date, "" ) ));
   
   //print_r( $list );
   
   $idx=0;
   
   $domains=Array();
   
   foreach ( $list as $line ) {
      $field = explode( ",", $line );
	  //print_r( explode (",", $line ) );
	  if ( ( $field[0] != '' ) && ( $field[0] != '-' ) && ( $field[0] != '[Domain]' ) ) {
	     $domains[$field[0]]["rcvd"] += $field[2];
	     $domains[$field[0]]["sent"] += $field[4];
	     $domains[$field[0]]["relay"] += $field[6];
	     $domains[$field[0]]["acct"] += 1;
	     $domains["*"]["acct"] += 1;
		 
		 if ( ( $field[0] != '*' ) && ( $act_domain != $field[0] ) ) {
		    echo "Opening domain ".$field[0]."\n";
			$domainobj=$com->OpenDomain($field[0]);
			$act_domain = $field[0];
		 
			list($account,$nul)=explode(";", $field[1], 2);
			$acc = $domainobj->OpenAccount($account.'@'.$field[0]);
			$SendLimitNumber = $acc->GetProperty("U_NumberSendLimit");
		 
			//echo "$account@".$field[0]." Limite: $SendLimitNumber\n";
		 
			// Se l'utente ha superato la soglia degli invii blocca l'account e avvisa
			if ( ( $field[6] > MAX_RELAY ) || 
				 (( $SendLimitNumber>0 ) && ( $field[6] >= $SendLimitNumber )) ){
				$msg .= "Account $account@".$field[0]." inviati: ".$field[6]." messaggi\n";
			}
		
		}
	  }
   }
   
   $domains["*"]["acct"] -= 1;
   
   //print_r( $domains );
}


// Controlli sui dati dei giorni precedenti
ReadOnlyData( "SMTP_RECVD_MSGS", $last['SMTP_RECVD_MSGS'] );
ReadOnlyData( "SMTP_SENT_MSGS", $last['SMTP_SENT_MSGS'] );
ReadOnlyData( "SMTP_RELAY_MSGS", $last['SMTP_RELAY_MSGS'] );
$previous=min($last);

ReadOnlyData( "SMTP_RECVD_MSGS_W", $last_w['SMTP_RECVD_MSGS_W'] );
ReadOnlyData( "SMTP_SENT_MSGS_W", $last_w['SMTP_SENT_MSGS_W'] );
ReadOnlyData( "SMTP_RELAY_MSGS_W", $last_w['SMTP_RELAY_MSGS_W'] );
$previous_w=min($last_w);

echo "Updating data\n";
for ( $idx=DAYS_OF_DATA; $idx>=1; $idx-- ) {

  $all_days=FALSE;
  $mon2fri=FALSE;
  
  // Tutti i giorni
  if ( $previous < date("Ymd", mktime( 0, 0, 0, date("n"), date("j")-$idx, date("Y") )) ) {
     $all_days=TRUE;
  }
  
  // Dal luned al venerd
  $w=date("w", mktime( 0, 0, 0, date("n"), date("j")-$idx, date("Y") ));
  if ( ( $previous_w < date("Ymd", mktime( 0, 0, 0, date("n"), date("j")-$idx, date("Y") )) ) &&
       ( $w > 0 ) && ( $w<6 ) ) {
		$mon2fri=TRUE;
	}
	
  if ( $all_days || $mon2fri ) {
     $quando=date("Y-m-d", mktime( 0, 0, 0, date("n"), date("j")-$idx, date("Y") ));
	 echo "Adding data for $quando\n";
     GetMailStatistics( $quando, $msg );
	 //echo "$quando R:".$domains["*"]["rcvd"]." S:".$domains["*"]["sent"]." Re:".$domains["*"]["relay"]."\n";
	 if ( $all_days ) {
	    echo "All days data\n";
		AddData("SMTP_RECVD_MSGS", DAYS_OF_DATA, date("Ymd", mktime( 0, 0, 0, date("n"), date("j")-$idx, date("Y") )), $domains["*"]["rcvd"] );
		AddData("SMTP_SENT_MSGS", DAYS_OF_DATA, date("Ymd", mktime( 0, 0, 0, date("n"), date("j")-$idx, date("Y") )), $domains["*"]["sent"] );
		AddData("SMTP_RELAY_MSGS", DAYS_OF_DATA, date("Ymd", mktime( 0, 0, 0, date("n"), date("j")-$idx, date("Y") )), $domains["*"]["relay"] );
		echo "Checking traffic\n";
		CheckValue( "SMTP_RECVD_MSGS", $msg );
		CheckValue( "SMTP_SENT_MSGS", $msg );
		CheckValue( "SMTP_RELAY_MSGS", $msg );
	}
	
	if ( $mon2fri ) {
	    echo "Mon2fri data\n";
		AddData("SMTP_RECVD_MSGS_W", DAYS_OF_DATA, date("Ymd", mktime( 0, 0, 0, date("n"), date("j")-$idx, date("Y") )), $domains["*"]["rcvd"] );
		AddData("SMTP_SENT_MSGS_W", DAYS_OF_DATA, date("Ymd", mktime( 0, 0, 0, date("n"), date("j")-$idx, date("Y") )), $domains["*"]["sent"] );
		AddData("SMTP_RELAY_MSGS_W", DAYS_OF_DATA, date("Ymd", mktime( 0, 0, 0, date("n"), date("j")-$idx, date("Y") )), $domains["*"]["relay"] );	 
		echo "Checking traffic\n";
		CheckValue( "SMTP_RECVD_MSGS_W", $msg );
		CheckValue( "SMTP_SENT_MSGS_W", $msg );
		CheckValue( "SMTP_RELAY_MSGS_W", $msg );
	}
  }
}

// Controlli sui dati di oggi (pu essere lanciato pi di una volta al giorno)
$domains=Array();
GetMailStatistics( date("Ymd"), $msg );

if ( $msg!="" ) {
   echo "MSG:\n$msg\n";
   $com = new COM("IceWarpCOM.Mailer");

   $com->RemoteHost = "localhost";
   $com->Helo = "localhost";

   $com->FromName = "Statistics";
   $com->FromAddress = "statistics@myserver.local";
   // Indirizzo sulla busta
   $com->MailFrom = "statistics@myserver.local";
   $com->AddRecipient("statistics@myserver.local", "Monitoraggio");

   $com->Subject = "Loganalyzer Statistics Alert for MyServer";
   $com->IsHTML = False;
   $com->BodyText = $msg;

   if (!$com->SendMail()) echo $com->Response;

   $com = null;
}
?>